/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Locale;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Column;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.LabelConverter;
import org.autoplot.dom.Plot;
import org.autoplot.dom.Row;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class AnnotationController
extends DomNodeController {
    private final Annotation annotation;
    private final Application dom;
    private final DasAnnotation dasAnnotation;
    private DasRow allRow;
    private DasColumn allColumn;
    PropertyChangeListener contextPropertyChangeListener;

    public AnnotationController(Application dom, Annotation annotation, DasAnnotation dasAnnotation) {
        super(annotation);
        this.dom = dom;
        this.annotation = annotation;
        this.bindTo(dasAnnotation);
        this.dasAnnotation = dasAnnotation;
        this.allRow = new DasRow(dasAnnotation.getCanvas(), 0.0, 1.0);
        this.allColumn = new DasColumn(dasAnnotation.getCanvas(), 0.0, 1.0);
        annotation.controller = this;
    }

    public Canvas getCanvas() {
        return this.dom.getCanvases(0);
    }

    public Converter getFontConverter(final DasCanvasComponent dcc) {
        return new Converter(){

            public Object convertForward(Object s) {
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr((String)((String)s));
                    if (dd[1] == 1.0 && dd[2] == 0.0) {
                        return Float.valueOf(0.0f);
                    }
                    Font f = dcc.getFont();
                    if (f == null) {
                        f = Font.decode(AnnotationController.this.dom.getOptions().getCanvasFont());
                    }
                    double parentSize = f.getSize2D();
                    double newSize = dd[1] * parentSize + dd[2];
                    return Float.valueOf((float)newSize);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    return Float.valueOf(0.0f);
                }
            }

            public Object convertReverse(Object t) {
                float size = ((Float)t).floatValue();
                if (size == 0.0f) {
                    return "1em";
                }
                Font f = dcc.getFont();
                if (f == null) {
                    f = Font.decode(AnnotationController.this.dom.getOptions().getCanvasFont());
                }
                double parentSize = f.getSize2D();
                double relativeSize = (double)size / parentSize;
                return String.format(Locale.US, "%.2fem", relativeSize);
            }
        };
    }

    private void bindTo(final DasAnnotation dasAnnotation) {
        final ApplicationController ac = this.dom.controller;
        dasAnnotation.setFontSize(0.0f);
        String plotId = this.annotation.getPlotId();
        if (plotId != null && plotId.length() > 0) {
            LabelConverter lc = new LabelConverter(this.dom, (Plot)DomUtil.getElementById(this.dom, plotId), null, null, this.annotation);
            ac.bind(this.annotation, "text", dasAnnotation, "text", lc);
        } else {
            ac.bind(this.annotation, "text", dasAnnotation, "text");
        }
        ac.bind(this.annotation, "url", dasAnnotation, "url");
        ac.bind(this.annotation, "fontSize", dasAnnotation, "fontSize", this.getFontConverter((DasCanvasComponent)dasAnnotation));
        ac.bind(this.annotation, "scale", dasAnnotation, "scale");
        ac.bind(this.annotation, "borderType", dasAnnotation, "borderType");
        ac.bind(this.annotation, "anchorPosition", dasAnnotation, "anchorPosition");
        ac.bind(this.annotation, "anchorType", dasAnnotation, "anchorType");
        ac.bind(this.annotation, "splitAnchorType", dasAnnotation, "splitAnchorType");
        ac.bind(this.annotation, "verticalAnchorType", dasAnnotation, "verticalAnchorType");
        ac.bind(this.annotation, "anchorOffset", dasAnnotation, "anchorOffset");
        ac.bind(this.annotation, "anchorBorderType", dasAnnotation, "anchorBorderType");
        ac.bind(this.annotation, "xrange", dasAnnotation, "xrange");
        ac.bind(this.annotation, "yrange", dasAnnotation, "yrange");
        ac.bind(this.annotation, "pointAtX", dasAnnotation, "pointAtX");
        ac.bind(this.annotation, "pointAtY", dasAnnotation, "pointAtY");
        ac.bind(this.annotation, "pointAtOffset", dasAnnotation, "pointAtOffset");
        ac.bind(this.annotation, "showArrow", dasAnnotation, "showArrow");
        ac.bind(this.annotation, "overrideColors", dasAnnotation, "overrideColors");
        ac.bind(this.annotation, "textColor", dasAnnotation, "textColor");
        ac.bind(this.annotation, "rotate", dasAnnotation, "rotate");
        ac.bind(this.annotation, "foreground", dasAnnotation, "foreground");
        ac.bind(this.annotation, "background", dasAnnotation, "background");
        ac.bind(this.annotation, "glow", dasAnnotation, "glow");
        this.annotation.addPropertyChangeListener("rowId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DomNodeController.logger.finer("propertyChange rowId");
                String id = (String)evt.getNewValue();
                Row r = null;
                if (id.length() > 0) {
                    r = (Row)DomUtil.getElementById(AnnotationController.this.dom.getCanvases(0), (String)evt.getNewValue());
                }
                if (r != null) {
                    dasAnnotation.setRow(r.controller.getDasRow());
                } else {
                    dasAnnotation.setRow(AnnotationController.this.allRow);
                }
            }
        });
        this.annotation.addPropertyChangeListener("columnId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                String id = (String)evt.getNewValue();
                Column r = null;
                if (id.length() > 0) {
                    r = (Column)DomUtil.getElementById(AnnotationController.this.dom.getCanvases(0), (String)evt.getNewValue());
                }
                if (r != null) {
                    dasAnnotation.setColumn(r.controller.getDasColumn());
                } else {
                    dasAnnotation.setColumn(AnnotationController.this.allColumn);
                }
            }
        });
        this.annotation.addPropertyChangeListener("plotId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                ac.unbind(AnnotationController.this.annotation, "text", dasAnnotation, "text");
                if (((String)evt.getNewValue()).length() == 0) {
                    dasAnnotation.setPlot(null);
                } else {
                    Plot plot;
                    Plot oldPlot = (Plot)DomUtil.getElementById(AnnotationController.this.dom, (String)evt.getOldValue(), true);
                    if (oldPlot != null && AnnotationController.this.contextPropertyChangeListener != null) {
                        oldPlot.getController().removePropertyChangeListener("activeDataSet", AnnotationController.this.contextPropertyChangeListener);
                        oldPlot.removePropertyChangeListener("context", AnnotationController.this.contextPropertyChangeListener);
                        oldPlot.getXaxis().removePropertyChangeListener("range", AnnotationController.this.contextPropertyChangeListener);
                    }
                    if ((plot = (Plot)DomUtil.getElementById(AnnotationController.this.dom, (String)evt.getNewValue(), true)) != null && plot.getId().length() > 0) {
                        LabelConverter lc = new LabelConverter(AnnotationController.this.dom, plot, plot.xaxis, null, AnnotationController.this.annotation);
                        AnnotationController.this.contextPropertyChangeListener = evt1 -> dasAnnotation.setText((String)lc.convertForward(AnnotationController.this.annotation.getText()));
                        plot.getController().addPropertyChangeListener("activeDataSet", AnnotationController.this.contextPropertyChangeListener);
                        plot.addPropertyChangeListener("context", AnnotationController.this.contextPropertyChangeListener);
                        plot.getXaxis().addPropertyChangeListener("range", AnnotationController.this.contextPropertyChangeListener);
                        ac.bind(AnnotationController.this.annotation, "text", dasAnnotation, "text", lc);
                    } else {
                        ac.bind(AnnotationController.this.annotation, "text", dasAnnotation, "text");
                    }
                    if (plot != null) {
                        DasPlot dasPlot = plot.getController().getDasPlot();
                        dasAnnotation.setPlot(dasPlot);
                    } else {
                        dasAnnotation.setPlot(null);
                    }
                }
            }
        });
        String p = this.annotation.getPlotId();
        this.annotation.setPlotId("");
        this.annotation.setPlotId(p);
        this.dom.getCanvases(0).addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent((PropertyChangeEvent)evt);
                ((AnnotationController)AnnotationController.this).annotation.propertyChangeSupport.firePropertyChange("fontSize", null, AnnotationController.this.annotation.getFontSize());
                dasAnnotation.resize();
            }
        });
    }

    protected void removeBindings() {
        ApplicationController ac = this.dom.controller;
        ac.unbind(this.annotation);
    }

    public DasAnnotation getDasAnnotation() {
        return this.dasAnnotation;
    }
}

